/**
 P16F648A
 dqTCR
 2006 Jul 17	Start

**/

#include <16F648A.h>
//////// Fuses: LP,XT,HS,EC,NOWDT,WDT,NOPUT,PUT,PROTECT,NOPROTECT,BROWNOUT
//////// Fuses: NOBROWNOUT,NOMCLR,MCLR,NOLVP,LVP,INTRC,EC_IO,INTRC_IO,EC
//////// Fuses: NOCPD,CPD
#fuses WDT, PUT, NOPROTECT, NOBROWNOUT, NOMCLR, NOLVP, INTRC_IO, NOCPD

#use fast_io(A)
#use fast_io(B)

#use delay(CLOCK=4000000)

#define RAND_MAX 60

// gpCu̐錾
#include <stdlib.h>

// 萔Ȃǂ̐錾

// ̖ڂo͂邽߂̃}XN
#define MASK_PORTA 0xF0
#define MASK_PORTB 0xF0

// ̖ڂ̏o̓p^[
const int diceArray[8] = {
//	RB3210
//	    RA3210
	0b00000000,
	0b01000000,
	0b00001100,
	0b01100001,
	0b00101101,
	0b01101101,
	0b00111111,
	0b10000000
};
// Ԗڂ̂P̖ڐp̓_p^[̃CfbNX
#define RED1 7

// |[gWX^
#byte port_a = 0x05
#byte port_b = 0x06

// BEEP o͒[q (RA7)
#bit beepOut = 0x5.7
// \o
#bit auxout = 0x5.6
// ԂP̖ڂgp邩ǂ
#bit redOne = 0x6.7
// X^[gXCb` (RB4)
#bit startSW = 0x6.4


// ϐȂǂ̐錾
int	diceNum;

// foCX̏ԏ
void initDevice(void)
{
	/* ̖ڂ̈ʒuƃ|[g
		 RA0@@@@ RA3
		 RA1 RB2	 RB0
		 RA2 RB3	 RB1

		RB3 ͂P̖ڐp̐ԐFLED
	*/

	/* PORT A
							I/O
		RA0/AN0				O	LED1
		RA1/AN1				O	LED2
		RA2/AN2/VREF			O	LED3
		RA3/AN3/CMP1			O	LED4
		RA4/T0CKI/CMP2		O	reserved
		RA5/MCLR/VPP			O	reserved
		RA6/OSC2/CLKOUT		O	reserved
		RA7/OSC1/CLKIN		O	BZ
	*/
	set_tris_a(0b00000000);

	/* PORT B
							I/O
		RB0/INT				O	LED5
		RB1/RX/DT				O	LED6
		RB2/TX/CK				O	LED7
		RB3/CCP1				O	LED-RED
		RB4/PGM				I	START SW
		RB5					I	reserved
		RB6/T1OSO/T1CKI/PGC	I	reserved
		RB7/T1OSO/PGD			I	RED-EYE
	*/
	set_tris_b(0b11110000);

	// Ӌ@\
	// Rp[^[W[iAiÓj
	setup_comparator(NC_NC_NC_NC);

	// CCPW[
	setup_ccp1(CCP_OFF);

	// VREFW[
	setup_vref(FALSE);

	// ^C}[֘A
	// TMR0
	setup_timer_0(RTCC_INTERNAL);
	// TMR1
	setup_timer_1(T1_DISABLED);
	// TMR2
	setup_timer_2(T2_DISABLED, 0, 1);

	// WDT̐ݒ
	setup_wdt(WDT_576MS);

	// 荞ݐݒ
	// RB4-7̕ωŊ荞݁iX[vjF\
	// enable_interrupts(INT_RB);
}

// ̖ڂ̕\
void dispDice(int nowDice)
{
	int dispPattern;

	// Ԗڂ̂P̏ꍇ
	if (redOne == 0 && nowDice == 1) {
		nowDice = RED1;
	}
	// |[go͗p\p^[̎擾
	dispPattern = diceArray[nowDice];

	// ܂
	output_a(port_a & MASK_PORTA);
	output_b(port_b & MASK_PORTB);

	// PORTAo
	output_a(port_a | (dispPattern & 0x0F));

	// PORTBo
	output_b(port_b | (dispPattern >> 4));
}

// ̖ڂω
int nextDice(int nowDice)
{
	// _֐gȂꍇ͏
	// nowDice = (nowDice % 6) + 1;

	// _ɖڂ𐶐
	nowDice = (rand() % 6) + 1;
	diceNum = nowDice;
	return nowDice;
}

// r[vo
void beep(void)
{
	int i;
	for(i = 0; i < 4; i++) {
		beepOut = 0;
		delay_us(125);
		beepOut = 1;
		delay_us(125);
		beepOut = 0;
	};
}

void longbeep(void)
{
	int i;
	for(i = 0; i < 255; i++) {
		beepOut = 0;
		delay_us(125);
		beepOut = 1;
		delay_us(125);
		beepOut = 0;
	};
}


// XCb`̓`FbN
int checkStart(void)
{
	if (startSW == 0) {
		// `^O҂
		delay_ms(5);
		if (startSW == 0) {
			return TRUE;
		} else {
			return FALSE;
		}
	} else {
		return FALSE;
	}
}

void main(void)
{
	// [Jϐ
	int nowDice;
	int loopTimes;
	int delayTime;

	// foCX̐ݒ
	initDevice();

	// 荞݋Jn
	//enable_interrupts(GLOBAL);

	// ϐ̏
	nowDice = 1;
	loopTimes = 0;

	// \
	dispDice(nowDice);

	while(TRUE) {
		restart_wdt();
		if(checkStart() == TRUE) {
			// {^Ăԉ葱
			while(startSW == 0) {
				restart_wdt();
				nowDice = nextDice(nowDice);
				dispDice(nowDice);
				// Ԉĉo
				if (loopTimes == 0)
					beep();
				loopTimes = ++loopTimes % 10;
			}

			// {^
			delayTime = 10;
			for (loopTimes = 0; loopTimes < 18; loopTimes++) {
				restart_wdt();
				nowDice = nextDice(nowDice);
				dispDice(nowDice);
				beep();
				// XɂƂƂ܂
				delay_ms(delayTime);
				delayTime += 12;
			}
			// m菈
			dispDice(nowDice);
			longbeep();
		}
	};
}
